<?php
ini_set( 'display_errors', 1 );
exit;
$api_key = 'tLIUULmMtdjq58tteHtFCdZqtpleEPGUQn85Y0qn39PaF7dpM75PGFWmMeXJloPf';
$api_secret = 'NZNQwTSfuTv07Qp1cFJ6mpVU2qpMrNJGsL24o2lRSXuNTlnmnSBCubuxo1gqtogG';
$symbol = 'BTCUSDT';
$quantity = 0.001;
$tp_percent = 0.0005;
$sl_percent = 0.005;
$position_file = __DIR__ . '/position.txt';

// Telegram Bot config
$telegram_token = '7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';
$telegram_chat_id = '7964239235';

function send_telegram($token, $chat_id, $msg) {
    $url = "https://api.telegram.org/bot$token/sendMessage";
    curl_setopt_array($ch = curl_init(), [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => ['chat_id' => $chat_id, 'text' => $msg]
    ]);
    curl_exec($ch); curl_close($ch);
}

function signed_request($method, $endpoint, $params, $api_key, $api_secret) {
    $params['timestamp'] = round(microtime(true) * 1000);
    $query = http_build_query($params);
    $signature = hash_hmac('sha256', $query, $api_secret);
    $url = "https://fapi.binance.com$endpoint?$query&signature=$signature";
    $headers = ["X-MBX-APIKEY: $api_key"];

    $opts = [CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => 1, CURLOPT_HTTPHEADER => $headers];
    if ($method === 'POST') $opts[CURLOPT_POST] = true;
    if ($method === 'DELETE') $opts[CURLOPT_CUSTOMREQUEST] = 'DELETE';

    $ch = curl_init(); curl_setopt_array($ch, $opts);
    $res = curl_exec($ch); curl_close($ch);
    return json_decode($res, true);
}

function get_price($symbol) {
    $res = file_get_contents("https://fapi.binance.com/fapi/v1/ticker/price?symbol=$symbol");
    return floatval(json_decode($res, true)['price']);
}

function get_klines($symbol, $interval = '1m', $limit = 100) {
    $res = file_get_contents("https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit");
    return array_map(fn($x) => floatval($x[4]), json_decode($res, true));
}

function ema($data, $period) {
    $k = 2 / ($period + 1);
    $ema = $data[0];
    for ($i = 1; $i < count($data); $i++) {
        $ema = $data[$i] * $k + $ema * (1 - $k);
    }
    return $ema;
}

function calculate_rsi($data, $period = 14) {
    $gains = $losses = [];
    for ($i = 1; $i < count($data); $i++) {
        $delta = $data[$i] - $data[$i - 1];
        $gains[] = max($delta, 0);
        $losses[] = abs(min($delta, 0));
    }
    $avg_gain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avg_loss = array_sum(array_slice($losses, 0, $period)) / $period;
    for ($i = $period; $i < count($gains); $i++) {
        $avg_gain = ($avg_gain * ($period - 1) + $gains[$i]) / $period;
        $avg_loss = ($avg_loss * ($period - 1) + $losses[$i]) / $period;
    }
    $rs = $avg_loss == 0 ? 100 : $avg_gain / $avg_loss;
    return 100 - (100 / (1 + $rs));
}

function calculate_macd($data, $short = 12, $long = 26, $signal = 9) {
    $ema_short = []; $ema_long = [];
    $k_short = 2 / ($short + 1); $k_long = 2 / ($long + 1);
    $ema_short[0] = $data[0]; $ema_long[0] = $data[0];
    for ($i = 1; $i < count($data); $i++) {
        $ema_short[$i] = $data[$i] * $k_short + $ema_short[$i - 1] * (1 - $k_short);
        $ema_long[$i] = $data[$i] * $k_long + $ema_long[$i - 1] * (1 - $k_long);
    }
    $macd = array_map(fn($a, $b) => $a - $b, $ema_short, $ema_long);
    $signal_line = [$macd[0]];
    $k_sig = 2 / ($signal + 1);
    for ($i = 1; $i < count($macd); $i++) {
        $signal_line[$i] = $macd[$i] * $k_sig + $signal_line[$i - 1] * (1 - $k_sig);
    }
    return ['macd' => end($macd), 'signal' => end($signal_line)];
}

function get_position($file) {
    return file_exists($file) ? trim(file_get_contents($file)) : 'none';
}

function update_position($file, $status) {
    file_put_contents($file, $status);
}

function reset_position($symbol, $api_key, $api_secret, $file) {
    
    $params = ["symbol" => $symbol]; // USDT-M pair
    $response = signed_request("GET", "/fapi/v2/positionRisk", $params, $api_key, $api_secret);
    if (!empty($response) && is_array($response)) {
        $position = $response[0];
        $positionAmt = floatval($position['positionAmt']);
    
        if ($positionAmt == 0) {
            update_position($file, 'none');
        }
    }
    
    /*$pos = signed_request('GET', '/fapi/v2/positionRisk', [], $api_key, $api_secret);
    foreach ($pos as $p) {
        if ($p['symbol'] === $symbol && floatval($p['positionAmt']) == 0.0) {
            update_position($file, 'none');
        }
    }*/
}

function trade($side, $symbol, $qty, $tp_percent, $sl_percent, $api_key, $api_secret, $file) {
    
    
    $params = ["symbol" => $symbol]; // USDT-M pair
    $response = signed_request("GET", "/fapi/v2/positionRisk", $params, $api_key, $api_secret);
    if (!empty($response) && is_array($response)) {
        $position = $response[0];
        $positionAmt = floatval($position['positionAmt']);
    
        if ($positionAmt == 0) {
            
        $price = get_price($symbol);
        $tp = $side === 'BUY' ? $price * (1 + $tp_percent) : $price * (1 - $tp_percent);
        $sl = $side === 'BUY' ? $price * (1 - $sl_percent) : $price * (1 + $sl_percent);
        $opp = $side === 'BUY' ? 'SELL' : 'BUY';  
        
        $tp = number_format($tp, 2, '.', '');
        $sl = number_format($sl, 2, '.', '');

        // Market entry
        /*signed_request('POST', '/fapi/v1/order', [
            'symbol' => $symbol, 'side' => $side, 'type' => 'MARKET', 'quantity' => $qty
        ], $api_key, $api_secret);
    
        // TP
        signed_request('POST', '/fapi/v1/order', [
            'symbol' => $symbol, 'side' => $opp, 'type' => 'TAKE_PROFIT_MARKET',
            'stopPrice' => $tp, 'closePosition' => 'true', 'timeInForce' => 'GTC'
        ], $api_key, $api_secret);*/
    
        // SL
        /*signed_request('POST', '/fapi/v1/order', [
            'symbol' => $symbol, 'side' => $opp, 'type' => 'STOP_MARKET',
            'stopPrice' => number_format($sl, 2, '.', ''), 'closePosition' => 'true', 'timeInForce' => 'GTC'
        ], $api_key, $api_secret);*/

    update_position($file, $side === 'BUY' ? 'long' : 'short');
    send_telegram($GLOBALS['telegram_token'], $GLOBALS['telegram_chat_id'], "🚨 $side $symbol \nPrice: $price \nTP: $tp \nSL: $sl");
        }
    }
}

// MAIN LOGIC
reset_position($symbol, $api_key, $api_secret, $position_file);

$prices = get_klines($symbol, '1m', 100);
$ema9 = ema(array_slice($prices, -9), 9);
$ema21 = ema(array_slice($prices, -21), 21);
$rsi = calculate_rsi($prices);
$macd = calculate_macd($prices);

$signal = 'NONE';
if ($ema9 > $ema21 && $rsi < 70 && $macd['macd'] > $macd['signal']) $signal = 'BUY';
elseif ($ema9 < $ema21 && $rsi > 30 && $macd['macd'] < $macd['signal']) $signal = 'SELL';

$current_position = get_position($position_file);

if ($signal === 'BUY' && $current_position === 'none') {
    trade('BUY', $symbol, $quantity, $tp_percent, $sl_percent, $api_key, $api_secret, $position_file);
} elseif ($signal === 'SELL' && $current_position === 'none') {
    trade('SELL', $symbol, $quantity, $tp_percent, $sl_percent, $api_key, $api_secret, $position_file);
} else {
    echo "[" . date('Y-m-d H:i:s') . "] No trade. Signal: $signal | Position: $current_position\n";
}