<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

if(!empty($_GET['code'])){
    $code = str_replace(' ', '', $_GET['code']);  

}else{
    $res = mysqli_query($con, "SELECT * FROM coin_list where status = 1 AND chk2 = 0 LIMIT 1");
    $coin   = mysqli_fetch_assoc($res);  
    $code = str_replace(' ', '', $coin['code']);
    
    $sql = 'UPDATE coin_list SET chk2 = 1 WHERE code ="'.$code.'"';
    mysqli_query($con, $sql);
    
    if($coin['ID']==48){
          $sql = 'UPDATE coin_list SET chk2 = 0 where status = 1 AND chk2 = 1';
          mysqli_query($con, $sql);
    }
}

function getLongSignal($symbol = 'BTCUSDT', $interval = '15m', $limit = 100): array {
    // Step 1: Fetch candle data
    //$url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$interval&limit=$limit";
    //$url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$interval&limit=$limit";
    
     $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    
    $data = json_decode(file_get_contents($url), true);

    if (!$data || !is_array($data)) {
        return ['error' => 'Failed to fetch candle data'];
    }

    // Step 2: Extract closing prices
    $closes = array_map(function($candle) {
        return floatval($candle[4]); // Closing price
    }, $data);

    // Step 3: Calculate RSI
    $rsi = calculateRSI($closes, 14);

    // Step 4: Calculate moving averages
    $ma_short = movingAverage($closes, 5);   // short-term MA
    $ma_long  = movingAverage($closes, 20);  // long-term MA

    // Step 5: Generate long signal
    $last_rsi = end($rsi);
    $last_ma_short = end($ma_short);
    $last_ma_long = end($ma_long);

    $signal = ($last_rsi < 30 && $last_ma_short > $last_ma_long) ? "LONG" : "WAIT";

    return [
        'symbol' => $symbol,
        'interval' => $interval,
        'rsi' => round($last_rsi, 6),
        'ma_short' => round($last_ma_short, 6),
        'ma_long' => round($last_ma_long, 6),
        'signal' => $signal
    ];
}

function getShortSignal($symbol = 'BTCUSDT', $interval = '15m', $limit = 100): array {
    // Step 1: Fetch candle data
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $data = json_decode(file_get_contents($url), true);

    if (!$data || !is_array($data)) {
        return ['error' => 'Failed to fetch candle data'];
    }

    // Step 2: Extract closing prices
    $closes = array_map(function($candle) {
        return floatval($candle[4]); // Closing price
    }, $data);

    // Step 3: Calculate RSI
    $rsi = calculateRSI($closes, 14);

    // Step 4: Calculate moving averages
    $ma_short = movingAverage($closes, 5);   // short-term MA
    $ma_long  = movingAverage($closes, 20);  // long-term MA

    // Step 5: Generate short signal
    $last_rsi = end($rsi);
    $last_ma_short = end($ma_short);
    $last_ma_long = end($ma_long);

    $signal = ($last_rsi > 70 && $last_ma_short < $last_ma_long) ? "SHORT" : "WAIT";

    return [
        'symbol' => $symbol,
        'interval' => $interval,
        'rsi' => round($last_rsi, 6),
        'ma_short' => round($last_ma_short, 6),
        'ma_long' => round($last_ma_long, 6),
        'signal' => $signal
    ];
}


function calculateRSI($closes, $period = 14): array {
    $rsi = [];
    $gains = $losses = [];

    for ($i = 1; $i < count($closes); $i++) {
        $change = $closes[$i] - $closes[$i - 1];
        $gains[] = max(0, $change);
        $losses[] = max(0, -$change);
    }

    $avg_gain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avg_loss = array_sum(array_slice($losses, 0, $period)) / $period;

    for ($i = $period; $i < count($gains); $i++) {
        $avg_gain = (($avg_gain * ($period - 1)) + $gains[$i]) / $period;
        $avg_loss = (($avg_loss * ($period - 1)) + $losses[$i]) / $period;
        $rs = $avg_loss == 0 ? 100 : $avg_gain / $avg_loss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }

    return $rsi;
}

function movingAverage($data, $period): array {
    $ma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = array_sum(array_slice($data, $i - $period + 1, $period));
        $ma[] = $sum / $period;
    }
    return $ma;
}


$binance_order_id = uniqid();


$result = getLongSignal($code, '1h'); 

if($result['signal']=='LONG'){
    $resultjson = json_encode($result);
    
    $sql = "INSERT INTO order_coin_2 (binance_order_id, code, type, rsi,   order_ma_short, order_ma_long) VALUES ('" . $binance_order_id . "', '" . $code . "', 'L', '".$result['rsi']."', '" . $result['ma_short'] . "', '" . $result['ma_long'] . "')";
    mysqli_query($con, $sql);
                    
}else{
    $result = getShortSignal($code, '1h');
    if($result['signal']=='SHORT'){
        $resultjson = json_encode($result);
        
        $sql = "INSERT INTO order_coin_2 (binance_order_id, code, type, rsi,  order_ma_short, order_ma_long) VALUES ('" . $binance_order_id . "', '" . $code . "', 'S', '".$result['rsi']."', '" . $result['ma_short'] . "', '" . $result['ma_long'] . "')";
        mysqli_query($con, $sql);
    }
}

if(!empty($result) && $result['signal']!='WAIT'){
$mail = new PHPMailer;
$mail->isSMTP(); 
$mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
$mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
$mail->Port = 465; // TLS only
$mail->SMTPSecure = 'ssl'; // ssl is depracated
$mail->SMTPAuth = true;
$mail->Username = 'binance@easywayb.com';
$mail->Password = 'VignzC;&?i29';
$mail->setFrom('binance@easywayb.com', 'binance');
//$mail->addReplyTo('@gmail.com', ' Name');
$mail->addAddress('info@easywayb.com', 'priyankar');
$mail->Subject = 'Binance signal for '.$code;
$mail->msgHTML($resultjson); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
//$mail->AltBody = 'HTML messaging not supported';
// $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file

if(!$mail->send()){
   // echo "Mailer Error: " . $mail->ErrorInfo;
}else{
    //echo "Message sent!";
    echo $resultjson;
    
}
}else{
    if(!empty($_GET['code'])){
        print_r($result);
    }
}