<?php
ini_set( 'display_errors', 1 );

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

function getHotUsdtCoins($limit = 5, $minVolume = 1000) {
     // Step 1: Get Futures exchange info
    $exchangeInfoUrl = "https://fapi.binance.com/fapi/v1/exchangeInfo";
    $exchangeJson = file_get_contents($exchangeInfoUrl);
    $exchangeData = json_decode($exchangeJson, true);

    // Get valid USDT-margined futures symbols
    $usdtSymbols = [];
    foreach ($exchangeData['symbols'] as $symbolInfo) {
        if (
            $symbolInfo['status'] === 'TRADING' &&
            $symbolInfo['quoteAsset'] === 'USDT'
        ) {
            $usdtSymbols[] = $symbolInfo['symbol'];
        }
    }

    // Step 2: Get 24h ticker price change stats
    $tickerUrl = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $tickerJson = file_get_contents($tickerUrl);
    $tickerData = json_decode($tickerJson, true);

    // Step 3: Filter only USDT futures symbols
    $hotCoins = array_filter($tickerData, function ($coin) use ($usdtSymbols, $minVolume) {
        return in_array($coin['symbol'], $usdtSymbols) &&
               floatval($coin['quoteVolume']) > $minVolume;
    });

    // Step 4: Sort by 24h price change percent (desc)
    usort($hotCoins, function ($a, $b) {
        return floatval($b['priceChangePercent']) <=> floatval($a['priceChangePercent']);
    });

    // Return top N
    return array_slice($hotCoins, 0, $limit);
}

function getShortSignal($symbol = 'BTCUSDT', $interval = '15m', $limit = 100): array {
    // Step 1: Fetch candle data
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $data = json_decode(file_get_contents($url), true);

    if (!$data || !is_array($data)) {
        return ['error' => 'Failed to fetch candle data'];
    }

    // Step 2: Extract closing prices
    $closes = array_map(function($candle) {
        return floatval($candle[4]); // Closing price
    }, $data);

    // Step 3: Calculate RSI
    $rsi = calculateRSI($closes, 14);

    // Step 4: Calculate moving averages
    $ma_short = movingAverage($closes, 5);   // short-term MA
    $ma_long  = movingAverage($closes, 20);  // long-term MA

    // Step 5: Generate short signal
    $last_rsi = end($rsi);
    $last_ma_short = end($ma_short);
    $last_ma_long = end($ma_long);

    $signal = ($last_rsi > 70 && $last_ma_short < $last_ma_long) ? "SHORT" : "WAIT";

    return [
        'symbol' => $symbol,
        'interval' => $interval,
        'rsi' => round($last_rsi, 6),
        'ma_short' => round($last_ma_short, 6),
        'ma_long' => round($last_ma_long, 6),
        'signal' => $signal
    ];
}


function calculateRSI($closes, $period = 14): array {
    $rsi = [];
    $gains = $losses = [];

    for ($i = 1; $i < count($closes); $i++) {
        $change = $closes[$i] - $closes[$i - 1];
        $gains[] = max(0, $change);
        $losses[] = max(0, -$change);
    }

    $avg_gain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avg_loss = array_sum(array_slice($losses, 0, $period)) / $period;

    for ($i = $period; $i < count($gains); $i++) {
        $avg_gain = (($avg_gain * ($period - 1)) + $gains[$i]) / $period;
        $avg_loss = (($avg_loss * ($period - 1)) + $losses[$i]) / $period;
        $rs = $avg_loss == 0 ? 100 : $avg_gain / $avg_loss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }

    return $rsi;
}

function movingAverage($data, $period): array {
    $ma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = array_sum(array_slice($data, $i - $period + 1, $period));
        $ma[] = $sum / $period;
    }
    return $ma;
}


$binance_order_id = uniqid();

// PHP 8+ required for str_ends_with()
// For older versions, use: substr($coin['symbol'], -4) === 'USDT'

// Example usage
$hotCoins = getHotUsdtCoins();
$html = '';
foreach ($hotCoins as $coin) {
    echo "🔥 {$coin['symbol']} | Change: {$coin['priceChangePercent']}% | Volume: {$coin['quoteVolume']}<br>";
    $result = getShortSignal($coin['symbol'], '1h');
    $sql = 'SELECT * FROM order_coin_2 where code = "'.$coin['symbol'].'" AND status = 1';
    $resultsql = mysqli_query($con, $sql);
    $row   = mysqli_fetch_assoc($resultsql);
    if(empty($row)){ 
        if($result['signal']=='SHORT'){
            $resultjson = json_encode($result);
            
            $sql = "INSERT INTO order_coin_2 (binance_order_id, code, type, rsi,  order_ma_short, order_ma_long) VALUES ('" . $binance_order_id . "', '" . $coin['symbol'] . "', 'S', '".$result['rsi']."', '" . $result['ma_short'] . "', '" . $result['ma_long'] . "')";
            mysqli_query($con, $sql);
            $html .= "🔥 {$coin['symbol']} | Change: {$coin['priceChangePercent']}% | Volume: {$coin['quoteVolume']}<br>";
        }
    }
}

if(!empty($result) && $result['signal']!='WAIT'){
$mail = new PHPMailer;
$mail->isSMTP(); 
$mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
$mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
$mail->Port = 465; // TLS only
$mail->SMTPSecure = 'ssl'; // ssl is depracated
$mail->SMTPAuth = true;
$mail->Username = 'binance@easywayb.com';
$mail->Password = 'VignzC;&?i29';
$mail->setFrom('binance@easywayb.com', 'binance');
//$mail->addReplyTo('@gmail.com', ' Name');
$mail->addAddress('info@easywayb.com', 'priyankar');
$mail->Subject = 'Binance signal ';
$mail->msgHTML($html); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
//$mail->AltBody = 'HTML messaging not supported';
// $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file

if(!$mail->send()){
   // echo "Mailer Error: " . $mail->ErrorInfo;
}else{
    //echo "Message sent!";
    echo $html;
    
}
}