<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

set_time_limit(0);
ini_set( 'display_errors', 1 );

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

function getJustStartedLosingCoins($limit = 5, $volumeThreshold = 10000000) {
    // Step 1: Get Binance Futures listed USDT pairs
    $exchangeInfoUrl = "https://fapi.binance.com/fapi/v1/exchangeInfo";
    $exchangeJson = file_get_contents($exchangeInfoUrl);
    $exchangeData = json_decode($exchangeJson, true);

    $usdtSymbols = [];
    foreach ($exchangeData['symbols'] as $symbol) {
        if ($symbol['status'] === 'TRADING' && $symbol['quoteAsset'] === 'USDT') {
            $arrayusdtSymbols[] = $symbol['symbol'];
        }
    }
    
    $numRandoms = 30;
    $usdtSymbols = array();

    $count = count($arrayusdtSymbols);

    if ($count >= $numRandoms) {

        while (count($usdtSymbols) < $numRandoms) {

            $random = $arrayusdtSymbols[rand(0, $count - 1)];

            if (!in_array($random, $usdtSymbols)) {

                array_push($usdtSymbols, $random);
            }
        }
    }

    // Step 2: Analyze 15m candles
    $justStartedLosing = [];

    foreach ($usdtSymbols as $symbol) {
        $klinesUrl = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=15m&limit=3";
        $klinesJson = @file_get_contents($klinesUrl);
        if (!$klinesJson) continue; // Skip if error

        $klines = json_decode($klinesJson, true);
        if (count($klines) < 3) continue;

        $prevCandle = $klines[count($klines) - 2]; // Previous closed
        $currCandle = $klines[count($klines) - 1]; // Current ongoing

        $prevOpen = floatval($prevCandle[1]);
        $prevClose = floatval($prevCandle[4]);

        $currOpen = floatval($currCandle[1]);
        $currClose = floatval($currCandle[4]);
        $currVolume = floatval($currCandle[7]); // Quote asset volume

        // Logic: prev bullish or neutral, now bearish + good volume
        if (
            $prevClose >= $prevOpen &&
            $currClose < $currOpen &&
            $currVolume >= $volumeThreshold
        ) {
            $justStartedLosing[] = [
                'symbol' => $symbol,
                'volume' => $currVolume,
                'change' => round((($currClose - $currOpen) / $currOpen) * 100, 2)
            ];
        }

        // Optional: sleep to avoid rate limits
        usleep(200000); // 200ms
    }

    // Step 3: Sort by how much they're dropping
    usort($justStartedLosing, function ($a, $b) {
        return $a['change'] <=> $b['change'];
    });

    return array_slice($justStartedLosing, 0, $limit);
}

$html = '';

// Example usage
$losers = getJustStartedLosingCoins();
foreach ($losers as $coin) {
    $html .= "🔻 {$coin['symbol']} | Change (15m): {$coin['change']}% | Volume: {$coin['volume']}\n";
}

if(!empty($html)){
    
    $html .= 'For short';
    
    
    $mail = new PHPMailer;
    $mail->isSMTP(); 
    $mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
    $mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
    $mail->Port = 465; // TLS only
    $mail->SMTPSecure = 'ssl'; // ssl is depracated
    $mail->SMTPAuth = true;
    $mail->Username = 'binance@easywayb.com';
    $mail->Password = 'VignzC;&?i29';
    $mail->setFrom('binance@easywayb.com', 'binance');
    //$mail->addReplyTo('@gmail.com', ' Name');
    $mail->addAddress('info@easywayb.com', 'priyankar');
    $mail->Subject = 'Binance signal';
    $mail->msgHTML($html); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
    //$mail->AltBody = 'HTML messaging not supported';
    // $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file
    
    if(!$mail->send()){
       // echo "Mailer Error: " . $mail->ErrorInfo;
    }else{
        //echo "Message sent!";
        echo $html;
        
    }
    
}