<?php

function getTopSymbolsByVolume() {
    $symbol = array();
    $symbol[] = 'BROCCOLIF3BUSDT';
    return $symbol;
}

$topSymbols = getTopSymbolsByVolume();


$signals = [];
foreach ($topSymbols as $symbol) { 
    $result = analyzeSymbol($symbol);
    if ($result) {
        $signals[] = $result;
    }
    if (count($signals) >= 1) break;
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.15) {
    if (empty($klines)) return null;

    // Get highs from klines
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}


function getKlines($symbol, $interval = '1h', $limit = 100) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function calculateSMA($data, $period) {
    $sma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = 0;
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function calculateRSI($prices, $period = 14) {
    $gains = $losses = [];
    for ($i = 1; $i <= $period; $i++) {
        $diff = $prices[$i] - $prices[$i - 1];
        if ($diff >= 0) $gains[] = $diff;
        else $losses[] = abs($diff);
    }
    $avgGain = array_sum($gains) / $period;
    $avgLoss = array_sum($losses) / $period;
    if ($avgLoss == 0) return 100;
    $rs = $avgGain / $avgLoss;
    return 100 - (100 / (1 + $rs));
}

function calculateEMA($data, $period) {
    $ema = [];
    $k = 2 / ($period + 1);
    $ema[] = array_sum(array_slice($data, 0, $period)) / $period;
    for ($i = $period; $i < count($data); $i++) {
        $ema[] = $data[$i] * $k + end($ema) * (1 - $k);
    }
    return $ema;
}

function calculateMACD($prices, $fast = 12, $slow = 26, $signal = 9) {
    $emaFast = calculateEMA($prices, $fast);
    $emaSlow = calculateEMA($prices, $slow);
    $macdLine = [];
    $start = count($emaFast) - count($emaSlow); // align EMAs
    for ($i = 0; $i < count($emaSlow); $i++) {
        $macdLine[] = $emaFast[$i + $start] - $emaSlow[$i];
    }
    $signalLine = calculateEMA($macdLine, $signal);
    return [end($macdLine), end($signalLine)];
}



function analyzeSymbol($symbol) {
    $klines = getKlines($symbol, '1h', 100);
    if (!$klines || count($klines) < 60) return false;

    $closes = array_map(fn($k) => floatval($k[4]), $klines);
    $price = end($closes);

    $sma50 = calculateSMA($closes, 50);
    $rsi = calculateRSI(array_slice($closes, -15), 14);
    [$macd, $signal] = calculateMACD($closes);
    
    $isLong = $price > end($sma50) && $rsi > 50 && $rsi < 70 && $macd > $signal;
 //   $isLong = $price > end($sma50) && $rsi < 30 && $macd > $signal;

    if ($isLong) {
        return [
            'symbol' => $symbol,
            'price' => $price,
            'rsi' => round($rsi, 2),
            'macd' => round($macd, 4),
            'macd_signal' => round($signal, 4),
           // 'take_profit' => calculateDynamicLongTP($price, $klines),   // +3%
            'take_profit' => calculateTakeProfit($price, 1.5),
            'stop_loss' => calculateDynamicLongSL($price, $klines),    // -1.5%
        ];
    }

    return false;
}

// MAIN


// === HELPER FUNCTION ===
function signedRequest($method, $endpoint, $params = [], $apiKey, $apiSecret)
{
    $timestamp = round(microtime(true) * 1000);
    $params['timestamp'] = $timestamp;

    $query = http_build_query($params, '', '&');
    $signature = hash_hmac('sha256', $query, $apiSecret);
    $query .= "&signature=" . $signature;

    $url = "https://fapi.binance.com" . $endpoint . "?" . $query;

    $headers = [
        "X-MBX-APIKEY: $apiKey"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new Exception('Curl error: ' . curl_error($ch));
    }
    curl_close($ch);

    return json_decode($response, true);
}



function getSymbolPrecision($symbol, $type) {
    
    $con = mysqli_connect("localhost", "easywayh_ekart", "easywayh_ekart", "easywayh_ekart");
    
    $sql = 'SELECT * FROM future_coin where symbol = "'.$symbol.'"';
    $result = mysqli_query($con, $sql);
    $row   = mysqli_fetch_assoc($result);
    
    if(!empty($row) && $type=='price_filter'){
        $size = $row['price_filter'];
        return $size;
       
    }elseif(!empty($row) && $type=='lot_size'){
       $size = $row['lot_size'];   
       return $size;
    }
   

   return false; 
}

function calculateLongOrderQuantity($availableMargin, $leverage, $entryPrice) {
    return ($availableMargin * $leverage) / $entryPrice;
}

function formatQuantity($quantity, $stepSize) {
    $precision = strlen(substr(strrchr(rtrim($stepSize, '0'), "."), 1));
    return number_format($quantity, $precision, '.', '');
}
function calculateTakeProfit(float $entryPrice, float $tpPercent = 3.0): float {
    return $entryPrice * (1 + $tpPercent / 100);
}


$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY'; 
$apiToken2 ='8154971158:AAFhEKfOrzg3O4EZSeRTqWQAluRwug9nEs0'; 

// === CONFIG ===
$apiKey = "tLIUULmMtdjq58tteHtFCdZqtpleEPGUQn85Y0qn39PaF7dpM75PGFWmMeXJloPf";
$apiSecret = "NZNQwTSfuTv07Qp1cFJ6mpVU2qpMrNJGsL24o2lRSXuNTlnmnSBCubuxo1gqtogG";

$availableMargin = 1;

// OUTPUT
if (count($signals) === 0) {
    echo "❌ No Long Signals Found\n";
} else {
    echo "✅ Top 2 Long Signals:\n\n";
    foreach ($signals as $signal) {
        
        $price_size = getSymbolPrecision($signal['symbol'], 'price_filter');
        
        if(empty($price_size)){
            break;
        }
        
        $step_size = getSymbolPrecision($signal['symbol'], 'lot_size');
        $entry = formatQuantity($signal['price'], $price_size);
        $tp = formatQuantity($signal['take_profit'], $price_size);
        $sl = formatQuantity($signal['stop_loss'], $price_size);
        
        echo "🔹 Symbol:       {$signal['symbol']}\n";
        echo "   Entry:        {$entry}\n";
        echo "   RSI:          {$signal['rsi']}\n";
        echo "   MACD:         {$signal['macd']} > {$signal['macd_signal']}\n";
        echo "🎯 Take Profit:  {$tp}\n";
        echo "🛑 Stop Loss:    {$sl}\n\n";
        
        $html = "{$signal['symbol']} - RSI {$signal['rsi']}% - MACD {$signal['macd']} > {$signal['macd_signal']} - Price: {$entry} - TP : {$tp} - SL : {$sl} - Custom Long MACD RSI \r\n";
        
        
        $data = [ 
            'chat_id' => '7964239235', 
            'text' => $html
        ]; 
         
        $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
        
        $data2 = [ 
            'chat_id' => '7207940112', 
            'text' => $html
        ]; 
     
        $response = file_get_contents('http://api.telegram.org/bot'.$apiToken2.'/sendMessage?' . http_build_query($data2) ); 
        
        $symbol = $signal['symbol'];
        
       $params = ["symbol" => $symbol]; // USDT-M pair
    
        $response = signedRequest("GET", "/fapi/v2/positionRisk", $params, $apiKey, $apiSecret);

        // Check liquidation status logic
        if (!empty($response) && is_array($response)) {
            $position = $response[0];
            $positionAmt = floatval($position['positionAmt']);
        
            if ($positionAmt == 0) {
                
                /*$leverageParams = [
                    "symbol" => $symbol,
                    "leverage" => 20
                ];
                $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                $leverage = 20;
                if(!empty($setLeverage['code'])){
                    $leverageParams = [
                        "symbol" => $symbol,
                        "leverage" => 15
                    ];
                    $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                    $leverage = 15;
                        if(!empty($setLeverage['code'])){
                            $leverageParams = [
                            "symbol" => $symbol,
                            "leverage" => 10
                        ];
                        $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                        $leverage = 10;
                    }
                }
    
                
                    
                    
                    $rawQuantity = calculateLongOrderQuantity($availableMargin, $leverage, $entry);
                    $quantity = formatQuantity($rawQuantity, $step_size);
                    
                    $orderParams = [
                        "symbol" => $symbol,
                        "side" => "BUY",             // LONG
                        "type" => "MARKET",
                        "quantity" => $quantity          // Adjust for your budget
                    ];
                    $marketOrder = signedRequest("POST", "/fapi/v1/order", $orderParams, $apiKey, $apiSecret);
                    
                    // === 3. SET TAKE PROFIT (SELL) ORDER ===
                   if (!empty($marketOrder['orderId'])) {
                        $tpParams = [
                            "symbol" => $symbol,
                            "side" => 'SELL',
                            "type" => "TAKE_PROFIT_MARKET",
                            "stopPrice" => $tp,
                            "quantity" => $quantity,
                            "timeInForce" => "GTC",
                            "reduceOnly" => "true",
                            "timestamp" => round(microtime(true) * 1000)
                        ];
                        $tpOrder = signedRequest("POST", "/fapi/v1/order", $tpParams, $apiKey, $apiSecret);*/
                        
                        /*$slParams = [
                            "symbol" => $symbol,
                            "side" => 'SELL',
                            "type" => "STOP_MARKET",
                            "stopPrice" => $sl,
                            "quantity" => $quantity,
                            "timeInForce" => "GTC",
                            "closePosition" => "true",
                            "timestamp" => round(microtime(true) * 1000)
                        ];
                        $slOrder = signedRequest("POST", "/fapi/v1/order", $slParams, $apiKey, $apiSecret);*/
                        
               //     }
                    
                
                
                }
            }
    }
}