<?php
ini_set( 'display_errors', 1 );
$con = mysqli_connect("localhost", "easywayh_ekart", "easywayh_ekart", "easywayh_ekart");

$res = mysqli_query($con, "SELECT * FROM future_coin where adx_cross = 'Y'");
$symbols = array();
while ($row = $res->fetch_assoc()) { 
  $code = $row['symbol'];
  $symbols[] = $code;
  
}


$interval = "1h";
$limit = 100;

// Helper: EMA
function ema(array $data, int $period): array {
    $multiplier = 2 / ($period + 1);
    $ema = [];
    $ema[0] = array_sum(array_slice($data, 0, $period)) / $period;
    for ($i = $period; $i < count($data); $i++) {
        $ema[] = ($data[$i] - end($ema)) * $multiplier + end($ema);
    }
    return array_pad($ema, count($data), null);
}

// RSI
function rsi(array $data, $period = 14): array {
    $gains = $losses = [];
    for ($i = 1; $i < count($data); $i++) {
        $delta = $data[$i] - $data[$i - 1];
        $gains[] = max($delta, 0);
        $losses[] = max(-$delta, 0);
    }
    $avgGain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avgLoss = array_sum(array_slice($losses, 0, $period)) / $period;

    $rsi = [];
    for ($i = $period; $i < count($gains); $i++) {
        $avgGain = ($avgGain * ($period - 1) + $gains[$i]) / $period;
        $avgLoss = ($avgLoss * ($period - 1) + $losses[$i]) / $period;
        $rs = $avgLoss == 0 ? 100 : $avgGain / $avgLoss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }
    return array_pad($rsi, count($data), null);
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get highs from klines
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}
function calculateTakeProfit(float $entryPrice, float $tpPercent = 3.0): float {
    return $entryPrice * (1 + $tpPercent / 100);
}

$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY'; 

//print_r($symbols);
foreach ($symbols as $symbol) {
    
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    
    // Get candle data
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = curl_exec($curl);
    curl_close($curl);
    
    $data = json_decode($response, true);
    
    // Extract closing prices
    $closes = array_map(fn($kline) => floatval($kline[4]), $data);
    $highs = array_map(fn($kline) => floatval($kline[2]), $data);
    $lows = array_map(fn($kline) => floatval($kline[3]), $data);
    
    $rsi = rsi($closes);
    
    // Last index
    $idx = count($closes) - 1;
    
    $rsiLow = $rsi[$idx] < 30;
    
    $entryPrice = $closes[$idx];
    
    $lowsidx = count($lows) - 1;
    $low = $lows[$lowsidx];
    
    $take_profit = calculateDynamicLongTP($entryPrice, $data);
    $take_profit_1 = calculateTakeProfit($entryPrice, 1.5);
    $stop_loss = calculateDynamicLongSL($entryPrice, $data);
    
    
    if ($rsiLow){
        // Long signal
        
        
        
        $html = "{$symbol} - Price: {$entryPrice} - Low Price: {$low} - TP : {$take_profit} - TP 1 : {$take_profit_1}- SL : {$stop_loss} - Long RSI Cross \r\n";
        $data = [ 
            'chat_id' => '7964239235', 
            'text' => $html
        ]; 
         
        $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
    }

    
    
    $sql = 'UPDATE future_coin SET rsi = "'.$rsi[$idx].'" WHERE symbol ="'.$symbol.'"';
    mysqli_query($con, $sql);
    
}