<?php
ini_set( 'display_errors', 1 );


require_once "../config.php";


function getTopLoserFuturesUsdtCoins($limit = 5, $minVolume = 10000000) {
    // Step 1: Get list of USDT Futures symbols
    $exchangeInfoUrl = "https://fapi.binance.com/fapi/v1/exchangeInfo";
    $exchangeJson = file_get_contents($exchangeInfoUrl);
    $exchangeData = json_decode($exchangeJson, true);

    $usdtSymbols = [];
    foreach ($exchangeData['symbols'] as $symbol) {
        if (
            $symbol['status'] === 'TRADING' &&
            $symbol['quoteAsset'] === 'USDT'
        ) {
            $usdtSymbols[] = $symbol['symbol'];
        }
    }

    // Step 2: Get 24h ticker statistics
    $tickerUrl = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $tickerJson = file_get_contents($tickerUrl);
    $tickerData = json_decode($tickerJson, true);

    // Step 3: Filter and collect only dropping coins with high volume
    $losers = array_filter($tickerData, function ($coin) use ($usdtSymbols, $minVolume) {
        return in_array($coin['symbol'], $usdtSymbols) &&
               floatval($coin['priceChangePercent']) < 0 &&
               floatval($coin['quoteVolume']) >= $minVolume;
    });

    // Step 4: Sort by biggest negative % change
    usort($losers, function ($a, $b) {
        return floatval($a['priceChangePercent']) <=> floatval($b['priceChangePercent']);
    });

    return array_slice($losers, 0, $limit);
}

function getFuturesKlines($symbol = 'BTCUSDT', $interval = '1h', $limit = 200) {
    /*$url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $json = file_get_contents($url);
    return json_decode($json, true);*/
    
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";  // limit 100 for the last 100 candles

    // Use cURL to fetch data from the API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the JSON response
    return json_decode($response, true);
}

function calculateSMA($data, $period) {
    $sma = []; //echo count($data) - $period;
    for ($i = 0; $i <= count($data) - $period; $i++) {
        $sum = 0;
        for ($j = $i; $j < $i + $period; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function checkLongSignal($symbol = 'BTCUSDT') {
    $klines = getFuturesKlines($symbol);
    
    $closingPrices = array_map(function($kline) {
        return floatval($kline[4]); // Closing price
    }, $klines);
   // echo $symbol;
   // print_r($closingPrices);

    $sma50 = calculateSMA($closingPrices, 50);
    $sma200 = calculateSMA($closingPrices, 200);

    $latestPrice = end($closingPrices);
    $latestSMA50 = end($sma50);
    $latestSMA200 = end($sma200);
    
   // echo $latestPrice.' - '.$latestSMA50.' - '.$latestSMA200;
   //echo ' <br> '. $latestPrice.' - '.$latestSMA50.' - '.$latestSMA200;


    if ($latestPrice > $latestSMA50 && $latestPrice > $latestSMA200 && $latestSMA50 > $latestSMA200) { 
        return true;
    } else {
        return false; 
    }
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get highs from klines
   // $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    $highs = array_map(function($k) {
        return floatval($k[2]); // Closing price
    }, $klines);
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
   // $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lows = array_map(function($k) {
        return floatval($k[3]); // Closing price
    }, $klines);
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}

$mail = false;

$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';

    $hotCoins = getTopLoserFuturesUsdtCoins();
    
    foreach ($hotCoins as $coin) {
        $coin_code = $coin['symbol'];
        
        
        $check = checkLongSignal($coin_code);  
            if($check==true){
                $binance_order_id = uniqid();
                $klines = getFuturesKlines($coin_code, "1h", 20);
                $checkPrice = checkPrice($coin_code);
                $tp = calculateDynamicLongTP($checkPrice['latestPrice'], $klines, 0.3);
                $sl = calculateDynamicLongSL($checkPrice['latestPrice'], $klines, 0.3);
                
                $html = "{$coin_code} - Price: {$checkPrice['latestPrice']} - TP : {$tp} - SL {$sl} - Long 2 \r\n";
                
                echo $html;
                $data = [ 
                    'chat_id' => '7964239235', 
                    'text' => $html
                ]; 
         
                $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
            }
        
        
}

