<?php
function getTopSymbolsByVolume($limit = 20) {
    $url = "https://api.binance.com/api/v3/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);

    $filtered = array_filter($data, function($d) {
        return str_ends_with($d['symbol'], 'USDT'); // Filter USDT pairs
    });

    usort($filtered, function($a, $b) {
        return floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']);
    });

    return array_slice(array_column($filtered, 'symbol'), 0, $limit);
}

function getKlines($symbol, $interval = '1h', $limit = 100) {
    $url = "https://api.binance.com/api/v3/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}
function calculateSMA($data, $period) {
    $sma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = 0;
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}
function hasLongSignal($symbol) {
    $klines = getKlines($symbol);
    if (!$klines || count($klines) < 50) return false;

    $closePrices = array_map(fn($k) => floatval($k[4]), $klines);
    $volumes = array_map(fn($k) => floatval($k[5]), $klines);

    $sma50 = calculateSMA($closePrices, 50);
    $latestPrice = end($closePrices);
    $latestSMA = end($sma50);

    $recentVolume = array_slice($volumes, -5);
    $volumeRising = $recentVolume[4] > $recentVolume[0];

    return $latestPrice > $latestSMA && $volumeRising;
}
$topSymbols = getTopSymbolsByVolume(30);
$longSignals = [];

foreach ($topSymbols as $symbol) {
    if (hasLongSignal($symbol)) {
        $longSignals[] = $symbol;
    }
    if (count($longSignals) >= 5) break;
}

echo "🔍 Top 5 Long Signals:\n";
foreach ($longSignals as $symbol) {
    echo "✅ $symbol\n";
}