<?php
function sendTelegramMessage($botToken, $chatId, $message) {
    $url = "https://api.telegram.org/bot$botToken/sendMessage";

    $postFields = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML' // Optional: supports bold, italics, links
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}

function getTopSymbolsByVolume($f = 0, $limit = 20) {
   // $url = "https://api.binance.com/api/v3/ticker/24hr";
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    $filtered = array_filter($data, fn($d) => str_ends_with($d['symbol'], 'USDT') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN'));
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

function getFuturesSymbols($f = 0, $limit = 20) {
   // $url = "https://api.binance.com/api/v3/ticker/24hr";
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
   // $filtered = array_filter($data, fn($d) => str_ends_with($d['symbol'], 'USDT') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN'));
    
    $filtered = array_filter($data, function($d) {
        return str_ends_with($d['symbol'], 'USDT') && !str_starts_with($d['symbol'], '1000') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN');
    });
    
    
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

/*function getFuturesSymbols($f = 0, $limit = 20) {
   // $url = 'https://fapi.binance.com/fapi/v1/ticker/price';
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $data = json_decode(file_get_contents($url), true);
    $symbols = [];

    foreach ($data as $item) {
        if (str_ends_with($item['symbol'], 'USDT') && $item['price'] < 1 ) {
            $symbols[] = $item['symbol'];
        }
    }
    $symbols = array_slice($symbols, $f, $limit);
    return $symbols;
}*/

// RSI calculation
    function calculateRSI($closes, $period = 14) {
        $gains = $losses = [];
        for ($i = 1; $i < count($closes); $i++) {
            $delta = $closes[$i] - $closes[$i - 1];
            $gains[] = max($delta, 0);
            $losses[] = max(-$delta, 0);
        }
        $avgGain = array_sum(array_slice($gains, -$period)) / $period;
        $avgLoss = array_sum(array_slice($losses, -$period)) / $period;
        if ($avgLoss == 0) return 100;
        $rs = $avgGain / $avgLoss;
        return 100 - (100 / (1 + $rs));
    }

    // MACD calculation
    function calculateMACD($closes, $fast = 12, $slow = 26, $signal = 9) {
        $ema = function($data, $period) {
            $alpha = 2 / ($period + 1);
            $ema = [$data[0]];
            for ($i = 1; $i < count($data); $i++) {
                $ema[] = $alpha * $data[$i] + (1 - $alpha) * end($ema);
            }
            return $ema;
        };
        $fastEMA = $ema($closes, $fast);
        $slowEMA = $ema($closes, $slow);
        $macdLine = array_map(fn($f, $s) => $f - $s, $fastEMA, $slowEMA);
        $signalLine = $ema($macdLine, $signal);

        return [
            'macd' => end($macdLine),
            'signal' => end($signalLine),
            'histogram' => end($macdLine) - end($signalLine)
        ];
    }

    // ATR calculation
    function calculateATR($highs, $lows, $closes, $period = 14) {
        $trs = [];
        for ($i = 1; $i < count($closes); $i++) {
            $high = $highs[$i];
            $low = $lows[$i];
            $prevClose = $closes[$i - 1];
            $tr = max($high - $low, abs($high - $prevClose), abs($low - $prevClose));
            $trs[] = $tr;
        }
        return array_sum(array_slice($trs, -$period)) / $period;
    }

    // Support & Resistance finder
    function findSupportResistance($highs, $lows, $lookback = 10) {
        $resistance = max(array_slice($highs, -$lookback - 1, $lookback));
        $support = min(array_slice($lows, -$lookback - 1, $lookback));
        return [$support, $resistance];
    }

    // Bullish Engulfing pattern detector
    function isBullishEngulfing($opens, $closes) {
        $last = count($opens) - 1;
        $prev = $last - 1;

        if ($closes[$last] <= $opens[$last]) return false; // Current candle green?
        if ($closes[$prev] >= $opens[$prev]) return false; // Previous candle red?

        $currentBodyLow = min($opens[$last], $closes[$last]);
        $currentBodyHigh = max($opens[$last], $closes[$last]);
        $prevBodyLow = min($opens[$prev], $closes[$prev]);
        $prevBodyHigh = max($opens[$prev], $closes[$prev]);

        return ($currentBodyLow < $prevBodyLow) && ($currentBodyHigh > $prevBodyHigh);
    }

function detectLongSignalFull($symbol = 'BTCUSDT', $interval = '15m', $limit = 50) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);
    $response = curl_exec($curl);
    curl_close($curl);

    $klines = json_decode($response, true);
    if (!$klines || !is_array($klines)) return false;

    // Extract OHLCV data
    $opens = array_map(fn($k) => (float)$k[1], $klines);
    $highs = array_map(fn($k) => (float)$k[2], $klines);
    $lows = array_map(fn($k) => (float)$k[3], $klines);
    $closes = array_map(fn($k) => (float)$k[4], $klines);
    $volumes = array_map(fn($k) => (float)$k[5], $klines);

    $price = end($closes);
    $currentVolume = end($volumes);

    

    // Calculate indicators
    $rsi = calculateRSI($closes);
    $macd = calculateMACD($closes);
    $atr = calculateATR($highs, $lows, $closes);
    list($support, $resistance) = findSupportResistance($highs, $lows);
    $bullishEngulfing = isBullishEngulfing($opens, $closes);

    // Volume filter
    $avgVolume = array_sum(array_slice($volumes, -11, 10)) / 10;
    $volumeSpike = $currentVolume > 1.5 * $avgVolume;

    // Price breakout check
    $recentHigh = max(array_slice($highs, -10, 9));
    $breakout = $price > $recentHigh;

    // Signal conditions
    $macdBullish = $macd['macd'] > $macd['signal'];
    $rsiGood = $rsi > 40 && $rsi < 70;

    // Entry price
    $entryPrice = $price;

    // ATR-based TP/SL
    $takeProfitATR = round($entryPrice + 3 * $atr, 4);
    $stopLossATR = round($entryPrice - 1.5 * $atr, 4);

    // Support/Resistance TP/SL with margin
    $takeProfitSR = round($resistance * 0.995, 4);
    $stopLossSR = round($support * 1.005, 4);

    // Decide which TP/SL to use (choose more conservative SL and TP)
    $takeProfit = min($takeProfitATR, $takeProfitSR);
    $stopLoss = max($stopLossATR, $stopLossSR);

    // Final signal condition with candle confirmation
    $longSignal = ($breakout && $macdBullish && $rsiGood && $volumeSpike && $bullishEngulfing);

    return [
        'symbol' => $symbol,
        'price' => $price,
        'rsi' => round($rsi, 2),
        'macd' => round($macd['macd'], 4),
        'signal_line' => round($macd['signal'], 4),
        'atr' => round($atr, 4),
        'breakout' => $breakout,
        'volume' => round($currentVolume, 2),
        'avg_volume' => round($avgVolume, 2),
        'volume_spike' => $volumeSpike,
        'macd_bullish' => $macdBullish,
        'bullish_engulfing' => $bullishEngulfing,
        'support' => round($support, 4),
        'resistance' => round($resistance, 4),
        'take_profit' => $takeProfit,
        'stop_loss' => $stopLoss,
        'long_signal' => $longSignal,
    ];
}

$symbols = getFuturesSymbols(0, 20); 
$symbols[] = 'BROCCOLIF3BUSDT';

$botToken = '7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';
$chatId = '7964239235';



foreach ($symbols as $symbol) { 
    $signal = detectLongSignalFull($symbol);
    if ($signal['long_signal']) {
        /*echo "[LONG SIGNAL] {$signal['symbol']} | Price: {$signal['price']} | RSI: {$signal['rsi']} | Vol: {$signal['volume']} > Avg: {$signal['avg_volume']} | MACD: {$signal['macd']} > {$signal['signal_line']}\n";
        echo "Bullish Engulfing: " . ($signal['bullish_engulfing'] ? 'Yes' : 'No') . "\n";
        echo "TP: {$signal['take_profit']} | SL: {$signal['stop_loss']} | ATR: {$signal['atr']}\n\n";*/
        
        $msg = "<b>LONG SIGNAL</b> on {$signal['symbol']}\n";
        $msg .= "Price: {$signal['price']}\n";
        $msg .= "RSI: {$signal['rsi']}\n";
        $msg .= "Volume: {$signal['volume']} (Avg: {$signal['avg_volume']})\n";
        $msg .= "MACD Bullish: " . ($signal['macd_bullish'] ? 'Yes' : 'No') . "\n";
        $msg .= "Bullish Engulfing: " . ($signal['bullish_engulfing'] ? 'Yes' : 'No') . "\n";
        $msg .= "TP: {$signal['take_profit']} | SL: {$signal['stop_loss']}\n";
    
        sendTelegramMessage($botToken, $chatId, $msg);
        
    } else {
     //   echo "[NO SIGNAL] {$signal['symbol']} | RSI: {$signal['rsi']} | Vol: {$signal['volume']} | Breakout: " . ($signal['breakout'] ? 'Yes' : 'No') . "\n";
    }
}


/*
$apiKey = 'YOUR_BINANCE_API_KEY';
$apiSecret = 'YOUR_BINANCE_API_SECRET';

function binanceFuturesRequest($endpoint, $params = [], $method = 'GET') {
    global $apiKey, $apiSecret;

    $baseUrl = "https://fapi.binance.com";
    $timestamp = round(microtime(true) * 1000);
    $params['timestamp'] = $timestamp;

    // Prepare query string
    ksort($params);
    $query = http_build_query($params);
    $signature = hash_hmac('sha256', $query, $apiSecret);
    $query .= "&signature=$signature";

    $url = $baseUrl . $endpoint . '?' . $query;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["X-MBX-APIKEY: $apiKey"]);

    if ($method == 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
    }

    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Place Market Order (BUY or SELL)
function placeMarketOrder($symbol, $side, $quantity) {
    return binanceFuturesRequest('/fapi/v1/order', [
        'symbol' => $symbol,
        'side' => $side,
        'type' => 'MARKET',
        'quantity' => $quantity,
        'recvWindow' => 5000,
    ], 'POST');
}

// Place Stop Loss and Take Profit Orders (using STOP_MARKET and TAKE_PROFIT_MARKET)
function placeSLTPOrders($symbol, $side, $quantity, $stopPrice, $takeProfitPrice) {
    // Stop Loss Order
    $slSide = $side === 'BUY' ? 'SELL' : 'BUY';
    $slOrder = binanceFuturesRequest('/fapi/v1/order', [
        'symbol' => $symbol,
        'side' => $slSide,
        'type' => 'STOP_MARKET',
        'stopPrice' => $stopPrice,
        'closePosition' => true,
        'recvWindow' => 5000,
    ], 'POST');

    // Take Profit Order
    $tpOrder = binanceFuturesRequest('/fapi/v1/order', [
        'symbol' => $symbol,
        'side' => $slSide,
        'type' => 'TAKE_PROFIT_MARKET',
        'stopPrice' => $takeProfitPrice,
        'closePosition' => true,
        'recvWindow' => 5000,
    ], 'POST');

    return ['slOrder' => $slOrder, 'tpOrder' => $tpOrder];
}

// Main Bot Loop (simple example)
$symbols = ['BTCUSDT', 'ETHUSDT'];
$quantity = 0.001; // Example fixed quantity per trade

foreach ($symbols as $symbol) {
    $signal = detectLongSignalFull($symbol); // Your integrated signal function
    
    if ($signal['long_signal']) {
        echo "Long signal on $symbol at price {$signal['price']}\n";

        // Check open positions here (implement yourself with /fapi/v2/positionRisk)

        // Place Market Buy Order
        $order = placeMarketOrder($symbol, 'BUY', $quantity);

        if (isset($order['orderId'])) {
            echo "Market buy order placed: Order ID {$order['orderId']}\n";

            // Place SL and TP orders
            $sltp = placeSLTPOrders($symbol, 'BUY', $quantity, $signal['stop_loss'], $signal['take_profit']);

            echo "Stop Loss and Take Profit orders placed\n";
        } else {
            echo "Order failed: " . json_encode($order) . "\n";
        }
    } else {
        echo "No long signal on $symbol\n";
    }
    sleep(1); // Avoid rate limits
}
*/