<?php
function getTopSymbolsByVolume($f = 0, $limit = 20) {
    $url = "https://api.binance.com/api/v3/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    $filtered = array_filter($data, fn($d) => str_ends_with($d['symbol'], 'USDT') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN'));
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

$test = getTopSymbolsByVolume(4,20);
print_r($test);