<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
ini_set( 'display_errors', 1 );
require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

$coin_list = array();

$res = mysqli_query($con, "SELECT * FROM order_coin where status = 1 AND type = 'L'");
while ($row = $res->fetch_assoc()) {
  $coin_list[] = str_replace(' ', '', $row['code']);
}

$coin_list = array_unique($coin_list); 

function getFuturesKlines($symbol = 'BTCUSDT', $interval = '1h', $limit = 20) {
    /*$url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $json = file_get_contents($url);
    return json_decode($json, true);*/
    
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";  // limit 100 for the last 100 candles

    // Use cURL to fetch data from the API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the JSON response
    return json_decode($response, true);
}

function calculateSMA($data, $period) {
    $sma = []; //echo count($data) - $period;
    for ($i = 0; $i <= count($data) - $period; $i++) {
        $sum = 0;
        for ($j = $i; $j < $i + $period; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function checkPrice($symbol = 'BTCUSDT') {
    $klines = getFuturesKlines($symbol);
    
    $closingPrices = array_map(function($kline) {
        return floatval($kline[4]); // Closing price
    }, $klines);

    $sma50 = calculateSMA($closingPrices, 5);
    $sma200 = calculateSMA($closingPrices, 20);

    $latestPrice = end($closingPrices);
    $latestSMA50 = end($sma50);
    $latestSMA200 = end($sma200);
    
    $price = array(
            'latestPrice' => $latestPrice,
            'latestSMA50' => $latestSMA50,
            'latestSMA200' => $latestSMA200
        );
    
    return $price;
}

$mail = false;
$html = false;

if(!empty($coin_list)){
    foreach($coin_list As $code){
        $checkPrice = checkPrice($code);
        
        $sql = 'SELECT * FROM order_coin where code = "'.$code.'" AND status = 1';
        $result = mysqli_query($con, $sql);
        $row   = mysqli_fetch_assoc($result);  
        
        if($row['take_profit'] <= $checkPrice['latestPrice']){
            
            $sql = 'UPDATE order_coin SET status = 0, close_price = "'.$checkPrice['latestPrice'].'", close_latest_price = "'.$checkPrice['latestPrice'].'", close_latestSMA50 = "'.$checkPrice['latestSMA50'].'", close_latestSMA200 = "'.$checkPrice['latestSMA200'].'", close_time = "'.date('Y-m-d H:i:s').'"  WHERE status = 1 AND code ="'.$code.'"';
           mysqli_query($con, $sql);
           
           $mail = true;
           
            $html .= '<table>';
            $html .= '<tr><td rownpan="2">Live Close LONG signal for '.$code.'</td></tr>';
            $html .= '<tr><td>Type</td><td>Long</td></tr>';
            $html .= '<tr><td>Bid Price</td><td>'.$row['bid_price'].'</td></tr>';
            $html .= '<tr><td>Latest Price</td><td>'.$checkPrice['latestPrice'].'</td></tr>';
            $html .= '</table>';
            $html .= '<br><br><br>';
        }else{
            $sql = 'UPDATE order_coin SET order_latest_price = "'.$checkPrice['latestPrice'].'" WHERE status = 1 AND code ="'.$code.'"';
                    mysqli_query($con, $sql);
        }
    }
}

if(!empty($mail)){
    $mail = new PHPMailer;
    $mail->isSMTP(); 
    $mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
    $mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
    $mail->Port = 465; // TLS only
    $mail->SMTPSecure = 'ssl'; // ssl is depracated
    $mail->SMTPAuth = true;
    $mail->Username = 'binance@easywayb.com';
    $mail->Password = 'VignzC;&?i29';
    $mail->setFrom('binance@easywayb.com', 'binance');
    //$mail->addReplyTo('@gmail.com', ' Name');
    $mail->addAddress('info@easywayb.com', 'priyankar');
    $mail->Subject = 'Binance close long signal';
    $mail->msgHTML($html); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
    //$mail->AltBody = 'HTML messaging not supported';
    // $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file
    
    if(!$mail->send()){
       // echo "Mailer Error: " . $mail->ErrorInfo;
    }else{
        //echo "Message sent!";
        echo $html;
        
    }
}