<?php
require_once "config.php";
?>
<!DOCTYPE html>
<html>
<head>
<style>
table {
  font-family: Arial, Helvetica, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

table td, table th {
  border: 1px solid #ddd;
  padding: 8px;
}

table tr:nth-child(even){background-color: #f2f2f2;}

table tr:hover {background-color: #ddd;}

table th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;
  color: white;
}

table.long th {
  background-color: #04AA6D;
}

table.long tr.complete td {
  background-color: #04aa6d96;
}

table.short th {
  background-color: #ff0000;
}

table.short tr.complete td {
  background-color: #f58181;
}

@media screen and (max-width: 600px) {
  table {
    border: 0;
  }

  table caption {
    font-size: 1.3em;
  }
  
  table thead {
    border: none;
    clip: rect(0 0 0 0);
    height: 1px;
    margin: -1px;
    overflow: hidden;
    padding: 0;
    position: absolute;
    width: 1px;
  }
  
  table tr {
    border-bottom: 3px solid #ddd;
    display: block;
    margin-bottom: .625em;
  }
  
  table td {
    border-bottom: 1px solid #ddd;
    display: block;
    font-size: .8em;
    text-align: right;
  }
  
  table td::before {
    /*
    * aria-label has no advantage, it won't be read inside a table
    content: attr(aria-label);
    */
    content: attr(data-label);
    float: left;
    font-weight: bold;
    text-transform: uppercase;
  }
  
  table td:last-child {
    border-bottom: 0;
  }
}
</style>
</head>
<body>
<?php
$res = mysqli_query($con, "SELECT *,  ((order_latest_price - bid_price) / 100) as increase FROM order_coin where type='L' ORDER BY increase DESC");

?>
<table class="long">
<tr><th scope="col">Code</th><th scope="col">Bid Price</th><th scope="col">Type</th><th scope="col">Order Time</th><th scope="col">Latest Price</th><th scope="col">SMA50</th><th scope="col">SMA200</th><th scope="col">TPL</th><th scope="col">SL</th><th>Profit</th></tr>    
<?php
while ($row = $res->fetch_assoc()) {
?>
<tr class="<?php echo ($row['status']!=1 ? 'complete' : ''); ?>"><td data-label="Code"><?php echo $row['code']; ?></td><td data-label="Bid Price"><?php echo $row['bid_price']; ?></td><td data-label="Type"><?php echo $row['type']; ?></td><td data-label="Order Time"><?php echo $row['order_time']; ?></td><td data-label="Latest Price"><?php echo $row['order_latest_price']; ?></td><td data-label="SMA50"><?php echo $row['order_latestSMA50']; ?></td><td data-label="SMA200"><?php echo $row['order_latestSMA200']; ?></td><td data-label="TPL"><?php echo $row['take_profit']; ?></td><td data-label="SL"><?php echo $row['stop_loss']; ?></td><td data-label="Profit"><?php echo round((($row['order_latest_price'] - $row['bid_price']) /  $row['bid_price']) * 100, 2); ?>%</td></tr>    
<?php
}
?>
</table>

<br><br><br><br><br><br>

<?php
$res = mysqli_query($con, "SELECT *,  ((bid_price - order_latest_price) /100) as decrease FROM order_coin where type='S' ORDER BY decrease DESC");

?>
<table class="short">
<tr><th scope="col">Code</th><th scope="col">Bid Price</th><th scope="col">Type</th><th scope="col">Order Time</th><th scope="col">Latest Price</th><th scope="col">SMA50</th><th scope="col">SMA200</th><th scope="col">TPL</th><th scope="col">SL</th><th>Profit</th></tr>    
<?php
while ($row = $res->fetch_assoc()) {
?>
<tr class="<?php echo ($row['status']!=1 ? 'complete' : ''); ?>"><td data-label="Code"><?php echo $row['code']; ?></td><td data-label="Bid Price"><?php echo $row['bid_price']; ?></td><td data-label="Type"><?php echo $row['type']; ?></td><td data-label="Order Time"><?php echo $row['order_time']; ?></td><td data-label="Latest Price"><?php echo $row['order_latest_price']; ?></td><td data-label="SMA50"><?php echo $row['order_latestSMA50']; ?></td><td data-label="SMA200"><?php echo $row['order_latestSMA200']; ?></td><td data-label="TPL"><?php echo $row['take_profit']; ?></td><td data-label="SL"><?php echo $row['stop_loss']; ?></td><td data-label="Profit"><?php echo round((($row['bid_price'] - $row['order_latest_price']) /  $row['order_latest_price']) * 100, 2); ?>%</td></tr>    
<?php
}
?>
</table>
</body>
</html>