<?php
//ini_set( 'display_errors', 1 );

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

function getFuturesKlines($symbol = 'BTCUSDT', $interval = '1h', $limit = 20) {
    /*$url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $json = file_get_contents($url);
    return json_decode($json, true);*/
    
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";  // limit 100 for the last 100 candles

    // Use cURL to fetch data from the API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the JSON response
    return json_decode($response, true);
}

function calculateSMA($data, $period) {
    $sma = []; //echo count($data) - $period;
    for ($i = 0; $i <= count($data) - $period; $i++) {
        $sum = 0;
        for ($j = $i; $j < $i + $period; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get highs from klines
   // $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    $highs = array_map(function($k) {
        return floatval($k[2]); // Closing price
    }, $klines);
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
   // $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lows = array_map(function($k) {
        return floatval($k[3]); // Closing price
    }, $klines);
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}



function Top_5_Long_Signals(){ 
    
$baseUrl = "https://fapi.binance.com";
$tickerUrl = "$baseUrl/fapi/v1/ticker/price";
$interval = "1h";
$limit = 2;
$minGain = 1.25;
$topN = 5;

// Step 1: Get all trading pairs
$symbolsData = json_decode(file_get_contents($tickerUrl), true);

// Filter only USDT pairs
$symbols = array_filter($symbolsData, function($s) {
    return substr($s['symbol'], -4) === 'USDT';
});

$symbols = (array_slice($symbols, 0 ,10));

// Step 2: For each symbol, fetch last 2 candles
$gainers = [];

foreach ($symbols as $item) {
    $symbol = $item['symbol'];
    $klineUrl = "$baseUrl/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    
    $candles = json_decode(@file_get_contents($klineUrl), true);
    if (!$candles || count($candles) < 2) continue;

    $prevClose = floatval($candles[0][4]);
    $currClose = floatval($candles[1][4]);

    $change = (($currClose - $prevClose) / $prevClose) * 100;

    if ($change >= $minGain) {
        $gainers[] = [
            'symbol' => $symbol,
            'change' => round($change, 2),
            'price' => $currClose
        ];
    }

    // Optional: delay to avoid hitting rate limits
    usleep(200000); // 0.2 sec
}

// Step 3: Sort gainers by change descending
usort($gainers, function($a, $b) {
    return $b['change'] <=> $a['change'];
});

// Step 4: Return top N gainers
return array_slice($gainers, 0, $topN);
}

$topGainers = Top_5_Long_Signals();

//print_r($topGainers);

$html = '';
foreach ($topGainers as $coin) {
    $klines = getFuturesKlines($coin['symbol'], "1h", 20);
    
    $tp = calculateDynamicLongTP($coin['price'], $klines, 0.3);
    $sl = calculateDynamicLongSL($coin['price'], $klines, 0.3);
                
    $html .= "{$coin['symbol']} - {$coin['change']}% - Price: {$coin['price']} - TP : {$tp} - SL : {$sl}<br>";
}

if(!empty($html)){
    $mail = new PHPMailer;
    $mail->isSMTP(); 
    $mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
    $mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
    $mail->Port = 465; // TLS only
    $mail->SMTPSecure = 'ssl'; // ssl is depracated
    $mail->SMTPAuth = true;
    $mail->Username = 'binance@easywayb.com';
    $mail->Password = 'VignzC;&?i29';
    $mail->setFrom('binance@easywayb.com', 'binance');
    //$mail->addReplyTo('@gmail.com', ' Name');
    $mail->addAddress('info@easywayb.com', 'priyankar');
    $mail->Subject = 'Binance top 5 long signal';
    $mail->msgHTML($html); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
    //$mail->AltBody = 'HTML messaging not supported';
    // $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file
    
    if(!$mail->send()){
       // echo "Mailer Error: " . $mail->ErrorInfo;
    }else{
        //echo "Message sent!";
        echo $html;
        
    }
}