<?php

function analyzeLongSymbol($symbol) {
    $klines = getKlines($symbol, '1h', 100);
    if (!$klines || count($klines) < 60) return false;

    $closes = array_map(fn($k) => floatval($k[4]), $klines);
    $price = end($closes);

    $sma50 = calculateSMA($closes, 50);
    $rsi = calculateRSI(array_slice($closes, -15), 14);
    [$macd, $signal] = calculateMACD($closes);
    
    $isLong = $price > end($sma50) && $rsi > 50 && $rsi < 70 && $macd > $signal;
    
    if ($isLong && $price < 1) {
        return [
            'symbol' => $symbol,
            'price' => $price,
            'rsi' => round($rsi, 2),
            'macd' => round($macd, 4),
            'macd_signal' => round($signal, 4),
            'take_profit' => calculateDynamicLongTP($price, $klines),   
            'stop_loss' => calculateDynamicLongSL($price, $klines),
        ];
    }

    return false;
}

function analyzeShortSignal($symbol) {
    $klines = getKlines($symbol, '1h', 100);
    if (!$klines || count($klines) < 60) return false;

    $closes = array_map(fn($k) => floatval($k[4]), $klines);
    $price = end($closes);

    $sma50 = calculateSMA($closes, 50);
    $rsi = calculateRSI(array_slice($closes, -15), 14);
    [$macd, $signal] = calculateMACD($closes);

    $isShort = $price < end($sma50) && ($rsi > 70 || $macd < $signal);

    if ($isShort) {
        return [
            'symbol' => $symbol,
            'price' => round($price, 4),
            'rsi' => round($rsi, 2),
            'macd' => round($macd, 4),
            'macd_signal' => round($signal, 4),
            'take_profit' => calculateDynamicShortTP($price, $klines),   // -3%
            'stop_loss' => calculateDynamicShortSL($price, $klines),    // +1.5%
        ];
    }

    return false;
}