<?php
function calculateDynamicShortTP($entryPrice, $klines, $bufferPercent = 0.15) {
    if (empty($klines)) return null;

    // Extract lowest "low" from recent candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low
    
    $lowestLow = min($lows);

    // Add small buffer (to increase TP hit rate)
    $takeProfit = $lowestLow + ($lowestLow * $bufferPercent / 100);

    // Ensure TP is below entry price
    return ($takeProfit < $entryPrice) ? round($takeProfit, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% lower
}

function calculateDynamicShortSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Extract highs from candles
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high
    $highestHigh = max($highs);

    // Add buffer (e.g., 0.3%) above resistance
    $stopLoss = $highestHigh + ($highestHigh * $bufferPercent / 100);

    // Make sure SL is above entry (as it's a short)
    return ($stopLoss > $entryPrice) ? round($stopLoss, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback 1% above
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.15) {
    if (empty($klines)) return null;

    // Get highs from klines
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}